IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_WMS_ENT_RET_RETORNO]') 
					AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [DBO].[P_EST_WMS_ENT_RET_RETORNO]
END
GO
--EXEC P_EST_WMS_ENT_RET_RETORNO 26142
CREATE PROCEDURE P_EST_WMS_ENT_RET_RETORNO @CD_PED_WMS_PAR INT = 0
AS
DECLARE @CD_PED_WMS INT

CREATE TABLE #RsProdProc 
(ORDEM INT IDENTITY(1,1),
CD_PED_WMS INT,
CD_EMP INT,
CD_CTR_PRE_ENTRADA INT,
CD_PROD INT,
QT_PROD MONEY,
LOTE VARCHAR(50),
CD_IT INT)

PRINT 'Confirmando pre-entrada - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);

DECLARE ProcWMSEnt CURSOR FAST_FORWARD
FOR SELECT
		DISTINCT PEND.CD_PED_WMS
	FROM
		EST_WMS_ENT_RET_PEND PEND
	WHERE
		PEND.CD_PED_WMS= CASE WHEN @CD_PED_WMS_PAR=0 THEN  PEND.CD_PED_WMS ELSE @CD_PED_WMS_PAR END 

OPEN ProcWMSEnt;
FETCH NEXT FROM ProcWMSEnt INTO @CD_PED_WMS;
WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO #RsProdProc
		SELECT 
			RET.CD_PED_WMS,
			PRE_ENT.CD_EMP,
			PRE_ENT.CD_CTR_PRE_ENTRADA,
			RET.CD_PROD,
			RET.QT_PROD,
			RET.LOTE,
			RET.CD_IT
		FROM
			EST_WMS_ENT_RET RET INNER JOIN EST_WMS_ENT_RET_PEND PEND ON
			RET.CD_PED_WMS = PEND.CD_PED_WMS AND
			RET.CD_IT = PEND.CD_IT
			INNER JOIN EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT PRE_ENT ON
			RET.CD_PED_WMS = PRE_ENT.CD_PED_WMS
		WHERE
			RET.CD_PED_WMS=@CD_PED_WMS

		INSERT INTO EST_NF_ENT_PRE_ENTRADA_CPL_CONF
		(CD_EMP, CD_CTR_PRE_ENTRADA, CD_ITEM, 
		CD_PROD, QT_IT_CONF, NR_LOTE, DT_VENCTO, 
		CD_USU, DT_CAD)
		SELECT
			P.CD_EMP,
			P.CD_CTR_PRE_ENTRADA,
			P.ORDEM,
			P.CD_PROD,
			P.QT_PROD,
			P.LOTE,
			NULL,
			1,
			GETDATE()
		FROM
			#RSPRODPROC P LEFT OUTER JOIN EST_NF_ENT_PRE_ENTRADA_CPL_CONF C ON
			P.CD_EMP = C.CD_EMP AND
			P.CD_CTR_PRE_ENTRADA = C.CD_CTR_PRE_ENTRADA AND
			P.CD_PROD = C.CD_PROD
		WHERE
			C.CD_PROD IS NULL
	
	INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA
	(CD_CTR,
	CD_USU,
	DT_CAD,
	CHECKIN_DIVERGENCIA,
	DT_TRANSACAO)
	SELECT
		DISTINCT EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR,
		1,
		CONVERT(CHAR(10),GETDATE(),112),
		0,
		GETDATE()
	FROM
		#RSPRODPROC P INNER JOIN  EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA ON
		P.CD_EMP = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_EMP AND
		P.CD_CTR_PRE_ENTRADA = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA
		LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA ON
		EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA.CD_CTR 
	WHERE
		EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA.CD_CTR  IS NULL

	INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL
	(CD_CTR,
	CD_EMP,
	CD_PROD,
	QT_IT_CHECK)
	SELECT
		EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR,
		P.CD_EMP,
		P.CD_PROD,
		SUM(P.QT_PROD)
	FROM
		#RSPRODPROC P INNER JOIN  EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA ON
		P.CD_EMP = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_EMP AND
		P.CD_CTR_PRE_ENTRADA = EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR_PRE_ENTRADA
		LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL ON
		EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR = EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL.CD_CTR 
	WHERE
		EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL.CD_CTR  IS NULL
	GROUP BY
		EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA.CD_CTR,
		P.CD_EMP,
		P.CD_PROD
	
	DELETE 
		FROM 		
		EST_WMS_ENT_RET_PEND 
	WHERE
		CD_PED_WMS= @CD_PED_WMS
	
TRUNCATE TABLE #RsProdProc

FETCH NEXT FROM ProcWMSEnt INTO @CD_PED_WMS;
END;
PRINT 'Concluido.';
CLOSE ProcWMSEnt;
DEALLOCATE ProcWMSEnt;

DROP TABLE #RsProdProc;

